<?php

	namespace App\Services;

	use \Illuminate\Database\Eloquent\Builder;

	class Debug{

		public static function getSql(Builder $query): string{
			return vsprintf(str_replace('?', '%s', $query->toSql()), collect($query->getBindings())->map(function ($binding) {
				return is_numeric($binding) ? $binding : "'{$binding}'";
			})->toArray());
		}
	}
