<?php

	namespace App;

	use App\Event;
	use App\EventKind;
	use App\UserGroup;
	use App\Http\Resources\Event as EventResource;
	use Illuminate\Database\Eloquent\Model;
	use Illuminate\Http\Request;
	use Illuminate\Http\UploadedFile;

	class Media extends Model{

		protected $fillable = ['name', 'file_name', 'path', 'group', 'created_by'];

		public function getUrl(){
			$url = env('APP_URL');
			if(!$url){
				$url = 'https://events.hassberge.de';
			}
			return $url . $this->path;
		}

		public static function createFromFile($file, $folder, Request $request = null){
			$group = strtolower($folder);
			if(!$folder){
				$folder = 'public';
			}else{
				$folder = 'public/' . $folder;
			}
			$path = $file->store($folder);

			$img = [
				'name' => $file->getBasename(),
				'file_name' => $file->getClientOriginalName(),
				'path' => str_replace('public', '/storage', $path),
				'group' => $group,
			];

			if($request){
				$img['created_by'] = $request->currentApiUser->group_id;
			}

			return self::create($img);
		}

		public static function createFromUpload(Request $request, $folder = '', $name = 'image'){
			$group = strtolower($folder);
			if(!$folder){
				$folder = 'public';
			}else{
				$folder = 'public/' . $folder;
			}

			$files = $request->file($name);

			if($files && count($files) == 1){
				$file = $files[0];
				$path = $file->store($folder);
				return self::create([
					'name' => $file->getBasename(),
					'file_name' => $file->getClientOriginalName(),
					'path' => str_replace('public', '/storage', $path),
					'group' => $group,
					'created_by' => $request->currentApiUser->group_id,
				]);
			}

			return false;
		}

		public function deleteRelations(){
			\DB::table('media_relations')
				->where([
					['media_id', '=', $this->id],
				])
				->delete();
		}

		public function getRelations(){
			$result = [];
			$db_res = \DB::table('media_relations')
				->select('foreign_id')
				->where([
					['media_id', '=', $this->id],
					['model', '=', Event::class],
				])
				->groupBy('foreign_id')
				->get()->all();

			foreach($db_res as $res){
				$result[] = new EventResource(Event::find($res->foreign_id));
			}
			return $result;
		}
	}
