<?php

	namespace App\Http\Resources;

	use App\Recommendation;
	use Illuminate\Http\Resources\Json\JsonResource;
	use App\UserGroupAuthority;
	use Illuminate\Support\Facades\DB;

	class Usergroup extends JsonResource{
		/**
		 * Transform the resource into an array.
		 *
		 * @param \Illuminate\Http\Request $request
		 * @return array
		 */
		public function toArray($request){
			$media = $this->getMedia()->first();

			if($media){
				$image = [
					'id' => $media->getAttribute('media_id'),
					'url' => $media->getUrl(),
					'name' => $media->file_name,
				];
			}else{
				$image = null;
			}

			$result =  [
				'id' => $this->id,
				'name' => $this->name,
				'email' => $this->email,
				'image' => $image,
			];
			if($request->get('withGroups', false)){
				$mains = UserGroupAuthority::select()
					->join('user_groups', 'user_group_main', '=', 'user_groups.id')
					->where('user_group_child', '=', $this->id)
					->get()
					->all();

				$result['userGroups'] = [];
				foreach($mains as $main){
					$result['userGroups'][] = $main->name;
				}
			}

			if($request->get('withChildren', false)){
				$children = UserGroupAuthority::select()
					->join('user_groups', 'user_group_child', '=', 'user_groups.id')
					->where('user_group_main', '=', $this->id)
					->get()
					->all();

				$result['userGroups'] = [];
				foreach($children as $child){
					$result['userGroups'][] = [
						'id' => $child->id,
						'name' => $child->name,
					];
				}
			}

			if($request->get('event', false)){
				$rec = Recommendation::select()
					->where([
						['user_group', '=', $this->id],
						['event', '=', $request->get('event')],
					])
					->get()->first();

				$result['recommended'] = $rec? 1 : 0;

				$release = DB::table('event_releases')
					->select('released')
					->where([
						['user_group', '=', $this->id],
						['event', '=', $request->get('event')],
					])
					->get()
					->first();

				$result['released'] = $release ? $release->released : 0;

			}

			return $result;
		}
	}
