<?php

	namespace App\Http\Resources;

	use Illuminate\Http\Resources\Json\JsonResource;
	use Illuminate\Support\Facades\DB;

	class UserGroupAuthority extends JsonResource{
		/**
		 * Transform the resource into an array.
		 *
		 * @param \Illuminate\Http\Request $request
		 * @return array
		 */
		public function toArray($request){
			$children = DB::table('user_group_authorities')
				->select('user_group_child')
				->where('user_group_main', '=', $this->user_group_main)
				->get()
				->all();
			$children = array_map(function($x){
				return $x->user_group_child;
			}, $children);

			$children = \App\UserGroup::query()
				->whereIn('id', $children)
				->get()
				->all();

			$userGroup = \App\UserGroup::find($this->user_group_main);

			$media = $userGroup->getMedia()->first();
			if($media){
				$image = [
					'id' => $media->getAttribute('media_id'),
					'url' => $media->getUrl(),
					'name' => $media->file_name,
				];
			}else{
				$image = null;
			}

			return [
				'id' => $this->user_group_main,
				'name' => $userGroup->name,
				'image' => $image,
				'children' => \App\Http\Resources\Usergroup::collection($children),
			];
		}
	}
