<?php

	namespace App\Http\Resources;

	use App\UserGroup;
	use Illuminate\Http\Resources\Json\JsonResource;

	class LraApiUser extends JsonResource{
		/**
		 * Transform the resource into an array.
		 *
		 * @param \Illuminate\Http\Request $request
		 * @return array
		 */
		public function toArray($request){
			$group = UserGroup::find($this->group_id);
			return [
				'id' => $this->id,
				'group_id' => $this->group_id,
				'group_name' => $group->name,
				'key' => $this->key,
				'domain' => $this->domain,
			];
		}
	}
