<?php

	namespace App\Http\Resources;

	use App\ApiUser;
	use App\UserGroup;
	use Illuminate\Http\Resources\Json\JsonResource;

	class LoggedInUser extends JsonResource{
		/**
		 * Transform the resource into an array.
		 *
		 * @param \Illuminate\Http\Request $request
		 * @return array
		 */
		public function toArray($request){
			$apiUser = \App\ApiUser::find($this->api_user);
			$group = UserGroup::find($apiUser->group_id);
			return [
				'token' => $apiUser->key,
				'name' => $this->name,
				'email' => $this->email,
				'group_id' => $group->id,
				'group_name' => $group->name,
			];
		}
	}
