<?php

	namespace App\Http\Resources;

	use Illuminate\Http\Resources\Json\JsonResource;

	class Location extends JsonResource{
		/**
		 * Transform the resource into an array.
		 *
		 * @param \Illuminate\Http\Request $request
		 * @return array
		 */
		public function toArray($request){
			$name = $this->name;

			$sub = '';
			if($this->parent){
				$sub .= ' ' . $this->parent->name;
			}

			if($sub){
				$name .= ' (' . trim($sub) . ')';
			}

			return array(
				'id' => $this->id,
				'name' => $name,
				'gps' => [
					'lat' => $this->gps? $this->gps->getLat() : null,
					'lng' => $this->gps? $this->gps->getLng() : null,
				],
				'parent' => $this->parent_id,
			);
		}
	}
