<?php

	namespace App\Http\Resources;

	use Illuminate\Http\Resources\Json\JsonResource;

	class FullEvent extends JsonResource{
		/**
		 * Transform the resource into an array.
		 *
		 * @param \Illuminate\Http\Request $request
		 * @return array
		 */
		public function toArray($request){
			$eventDate = \App\EventDate::find($this->id);
			$event = \App\Event::find($eventDate->event);
			$location = \App\Location::find($eventDate->location);

			$connectedEventdates = [];

			if(empty($event->id)){
				//dd($eventDate);
			}

			$eventDateQuery = \App\EventDate::select('id')
				->where('event', '=', $event->id)
				->get()
				->all();
			foreach($eventDateQuery as $ev){
				if($ev->id !== $eventDate->id){
					$connectedEventdates[] = $ev->id;
				}
			}

			$gps = [
				'lat' => '',
				'lng' => '',
			];

			if($eventDate->gps){
				$gps = [
					'lat' => $eventDate->gps? $eventDate->gps->getLat() : null,
					'lng' => $eventDate->gps? $eventDate->gps->getLng() : null,
				];
			}

			return [
				'id' => $this->id,
				'event' => new EventWithoutDate($event),
				'relatedDates' => $connectedEventdates,
				'location' => new Location($location),
				'gps' => $gps,
				'canceled' => $eventDate->canceled,
				'title' => $eventDate->title,
				'description' => $eventDate->description,
				'short_description' => $eventDate->short_description,
				'street' => $eventDate->street,
				'street_nr' => $eventDate->street_nr,
				'address_supplement' => $eventDate->address_supplement,
				'date_start' => $eventDate->date,
				'date_end' => $eventDate->date_end,
				'time_start' => $eventDate->start,
				'time_end' => $eventDate->end,
				'whole_day' => $eventDate->whole_day,
			];
		}
	}
