<?php

namespace App\Http\Resources;

use App\Services\GlobalCounter;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Facades\DB;

class EventRelease extends JsonResource
{
	/**
	 * Transform the resource into an array.
	 *
	 * @param \Illuminate\Http\Request $request
	 * @return array
	 */
    public function toArray($request)
    {
		$params = $request->all();
		if(empty($params['groups'])){
			$params['groups'] = [
				$request->currentApiUser->group_id,
			];
		}else{
			$params['groups'] = json_decode($params['groups'],1);
		}

    	$eventDate = \App\EventDate::select('date')
    		->where('event', '=', $this->id)
    		->orderBy('date', 'asc')
    		->get()
    		->first();

		$releases = [];

		foreach($params['groups'] as $userGroup){
			$release = DB::table('event_releases')
				->select('released')
				->where([
					['event', '=', $this->id],
					['user_group', '=', $userGroup],
				])
				->get()
				->first();
			$releases[] = [
				'userGroup' => $userGroup,
				'released' => $release ? $release->released : 0,
				'event' => $this->id,
			];
		}


        return [
        	'id' => $this->id,
        	'name' => $this->name,
			'eventDate' => $eventDate ? $eventDate->date : null,
			'releases' => $releases,
		];
    }
}
