<?php

	namespace App\Http\Resources;

	use App\EventDate;
	use App\EventKind;
	use App\Http\Resources\EventDate as EventDateResource;
	use App\Http\Resources\EventKind as EventKindResource;
	use App\Recommendation;
	use Illuminate\Http\Resources\Json\JsonResource;
	use Illuminate\Support\Facades\DB;

	class Event extends JsonResource{
		/**
		 * Transform the resource into an array.
		 *
		 * @param \Illuminate\Http\Request $request
		 * @return array
		 */
		public function toArray($request){
			$media = $this->getMedia();
			$images = Media::collection($media);
			$kind = new EventKindResource(EventKind::find($this->kind));
			$kind = $kind->toArray($request);
			$eventId = $this->id;
			if(isset($this->event) && $this->event){
				$eventId = $this->event;
			}
			$eventDates = EventDateResource::collection(EventDate::select()->where(['event' => $eventId])->get());
			$eventDates = $eventDates->toArray($request);
			$released = DB::table('event_releases')
				->select('released')
				->where('event', '=', $eventId)
				->where('user_group', '=', $request->currentApiUser->group_id)
				->get()
				->first();

			$date = isset($this->date)? $this->date : (isset($eventDates) && count($eventDates)? $eventDates[0]['date'] : '');


			$result = [
				'id' => $eventId,
				'name' => $this->name,
				'kind' => $kind,
				'status' => $this->status,
				'organisation' => $this->organisation,
				'web' => $this->web,
				'mail' => $this->mail,
				'phone' => $this->phone,
				'registration' => (bool) $this->registration,
				'price' => $this->price,
				'ticket_presale' => $this->ticket_presale,
				'free' => (bool) $this->free,
				'media' => $images,
				'eventDates' => $eventDates,
				'released' => ((isset($released->released))? $released->released : 0),
				'created_by' => $this->created_by,

				'facebook' => $this->facebook,
				'twitter' => $this->twitter,
				'instagram' => $this->instagram,

				'sustainability' => $this->sustainability,
				'accessible' => $this->accessible,
				'family_friendly' => $this->family_friendly,
				'with_cost' => $this->with_cost,
				'date' => $date,
				'uId' => $eventId . '--' . $date,
			];

			$created_by = \App\UserGroup::find($this->created_by);
			$result['created_by_name'] = '';
			if($created_by){
				$result['created_by_name'] = $created_by->name;
				$media = $created_by->getMedia();
				if($media->count()){
					$result['created_by_media'] = $media[0]->getUrl();
				}else{
					$result['created_by_media'] = '';
				}
				//
			}


			if($request->get('withSeen', false)){
				$rec = Recommendation::select()
					->where([
						['user_group', '=', $request->currentApiUser->group_id],
						['event', '=', $eventId],
					])
					->get()
					->first();
				$seen = 0;
				if($rec){
					$seen = $rec->seen;
				}

				$result['seen'] = $seen;
			}

			return $result;
		}
	}
