<?php

	namespace App\Http\Middleware;

	use Closure;

	class XContentHeader{

		/**
		 * @var string[]
		 */
		protected $disallowedHeaders = [
			'x-powerd-by',
			'host',
		];

		/**
		 * Handle an incoming request.
		 *
		 * @param \Illuminate\Http\Request $request
		 * @param Closure $next
		 * @return mixed
		 */
		public function handle($request, Closure $next){
			$response = $next($request);
			$response->headers->set('X-Content-Type-Options', 'nosniff');
			$this->removeDissallowedHeaders($response);
			return $response;
		}

		protected function removeDissallowedHeaders($response){
			foreach($this->disallowedHeaders as $header){
				$response->headers->remove($header);
			}
		}
	}
