<?php

namespace App\Http\Middleware;

use Closure;

class LogResponse
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        $response = $next($request);


		if($request->logEntry){
			$request->logEntry->response = $response->getContent();
			$request->logEntry->status = $response->getStatusCode();
			$request->logEntry->save();
		}

        return $response;
    }
}
