<?php

	namespace App\Http\Middleware;

	use Closure;
	use Illuminate\Http\Request;

	class Filter{

		const OPERATORS = [
			'like',
			'=',
			'>',
			'>=',
			'<',
			'<=',
			'!=',
			'is',
			'is not',
			'in',
		];

		/**
		 * Handle an incoming request.
		 *
		 * @param \Illuminate\Http\Request $request
		 * @param \Closure $next
		 * @return mixed
		 */
		public function handle($request, Closure $next){
			$filter = $request->input('filter', '{}');

			if(substr($filter, 0, 1) === '['){
				$this->handleList($filter, $request);
				return $next($request);
			}
			$filter = json_decode($filter, 1);

			if($filter === null){
				$filter = [];
			}
			$request->filter = [];
			foreach($filter as $key => $value){
				if(is_array($value) && count($value) == 2){
					$value[0] = strtolower($value[0]);
					if(!in_array($value[0], self::OPERATORS)){
						continue;
					}

					switch($value[0]){
						case 'like':
							$value[1] = '%' . implode('%', explode(' ', $value[1])) . '%';
							break;
					}

					$request->filter[] = array_merge(
						array($key),
						$value
					);
				}else{
					$request->filter[] = [$key, $value];
				}
			}
			return $next($request);
		}

		protected function handleList(string $filter, Request $request){
			$filter = json_decode($filter, 1);
			if($filter === null){
				$filter = [];
			}
			$request->filter = [];
			foreach($filter as $filterList){
				if(is_array($filterList) && count($filterList) === 3){
					$filterList[1] = strtolower($filterList[1]);
					if(!in_array($filterList[1], self::OPERATORS)){
						continue;
					}

					switch($filterList[1]){
						case 'like':
							$filterList[2] = '%' . implode('%', explode(' ', $filterList[2])) . '%';
							break;
					}

					$request->filter[] = $filterList;

				}else if(is_array($filterList) && count($filterList) === 2){
					$request->request->add([$filterList[0] => $filterList[1]]);
				}
			}
		}
	}
