<?php

	namespace App\Http\Middleware;

	use App\ApiAccessLog;
	use App\ApiUser;
	use App\RouteGroupRoute;
	use App\User;
	use Closure;
	use Illuminate\Support\Facades\Route;

	class ApiAuthentication{
		/**
		 * Handle an incoming request.
		 *
		 * @param \Illuminate\Http\Request $request
		 * @param \Closure $next
		 * @return mixed
		 */
		public function handle($request, Closure $next){
			$isAuthenticated = false;
			$auth = $request->header('Authorization', false);

			if($auth){
				$user = ApiUser::select()->where([
					'key' => str_replace('Bearer ', '', $auth),
					'domain' => parse_url(((isset($_SERVER['HTTP_ORIGIN']) && $_SERVER['HTTP_ORIGIN'])? $_SERVER['HTTP_ORIGIN'] : 'http://localhost'), \PHP_URL_HOST),
				])->first();
				if($user !== null){
					$isAuthenticated = true;
				}
			}


			if(!$isAuthenticated){
				return response()->json([
					'key' => str_replace('Bearer ', '', $auth),
					'domain' => parse_url(((isset($_SERVER['HTTP_ORIGIN']) && $_SERVER['HTTP_ORIGIN'])? $_SERVER['HTTP_ORIGIN'] : 'http://localhost'), \PHP_URL_HOST),
				], 401);
			}else if(isset($user)){

				$request->user = User::select('id')->where('api_user', '=', $user->id)->get()->first();
				$request->currentApiUser = $user;

				$currentRoute = Route::getCurrentRoute();

				$uri = $currentRoute->uri;
				$method = count($currentRoute->methods)? $currentRoute->methods[0] : 'GET';

				$route = \App\Route::where([
					['uri', '=', $uri],
					['method', '=', $method],
				])->get()->first();

				if(!$route){
					return response()->json(null, 404);
				}

				$route_group = $user->route_group;
				$routeAllowed = RouteGroupRoute::where([
					['route_group', '=', $route_group],
					['route', '=', $route->id],
				])->get()->first();

				if(!$routeAllowed){
					return response()->json(null, 401);
				}

				$request->logEntry = ApiAccessLog::create([
					'user' => $request->user? $request->user->id : null,
					'api_user' => $request->currentApiUser->id,
					'route' => $route->id,
					'parameter' => json_encode($request->all()),
				]);


			}
			return $next($request);
		}
	}
