<?php

	namespace App\Http\Controllers;

	use App\Http\Resources\UserGroupAuthority as UserGroupAuthorityResource;
	use App\UserGroupAuthority;
	use Illuminate\Http\Request;
	use Illuminate\Support\Facades\DB;

	class UserGroupAuthorityController extends Controller{
		public function index(Request $request){
			$query = UserGroupAuthority::query()
				->select('user_group_main')
				->groupBy('user_group_main')
				->paginate($request->pageSize)
				->appends(request()->query());
			return UserGroupAuthorityResource::collection($query);
		}

		public function show(int $authority){
			$userGroupAuth = UserGroupAuthority::query()
				->where('user_group_main', '=', $authority)
				->get()
				->first();
			return response()->json(new UserGroupAuthorityResource($userGroupAuth), 200);
		}

		public function store(Request $request){
			$params = $request->all();
			if($params['selectedAuthority']){
				foreach($params['groups'] as $group){
					UserGroupAuthority::create([
						'user_group_main' => $params['selectedAuthority'],
						'user_group_child' => $group,
					]);
				}
			}

			$userGroupAuth = UserGroupAuthority::query()
				->where('user_group_main', '=', $params['selectedAuthority'])
				->get()
				->first();

			return response()->json(new UserGroupAuthorityResource($userGroupAuth), 201);
		}

		public function update(Request $request){
			$params = $request->all();
			DB::table('user_group_authorities')
				->where('user_group_main', '=', $params['selectedAuthority'])
				->delete();

			foreach($params['groups'] as $group){
				if($group !== $params['selectedAuthority']){
					UserGroupAuthority::create([
						'user_group_main' => $params['selectedAuthority'],
						'user_group_child' => $group,
					]);
				}
			}

			$userGroupAuth = UserGroupAuthority::query()
				->where('user_group_main', '=', $params['selectedAuthority'])
				->get()
				->first();

			return response()->json(new UserGroupAuthorityResource($userGroupAuth), 200);
		}

		public function destroy(int $userGroup){
			DB::table('user_group_authorities')
				->where('user_group_main', '=', $userGroup)
				->delete();
			return response()->json(null, 204);
		}

	}
