<?php

	namespace App\Http\Controllers;

	use App\Http\Resources\Region as RegionResource;
	use App\Region;
	use Illuminate\Http\Request;

	class RegionController extends Controller{
		/**
		 * @param Request $request
		 * @return \Illuminate\Http\Resources\Json\AnonymousResourceCollection
		 */
		public function index(Request $request){
			$query = Region::select();
			foreach($request->filter as $value){
				if(in_array($value[0], Region::$filterable)){
					$query->orWhere(...$value);
				}
			}
			$query = $query->paginate($request->pageSize)
				->appends(request()->query());
			return RegionResource::collection($query);
		}

		public function store(Request $request){
			$region = Region::create($request->all());

			return response()->json($region, 201);
		}

		public function show(Region $region){
			return response()->json(new RegionResource($region), 200);
		}

		public function update(Request $request, Region $region){
			$region->update($request->all());

			return response()->json($region, 200);
		}

		public function destroy(Region $region){
			$region->delete();

			return response()->json(null, 204);
		}
	}
