<?php

	namespace App\Http\Controllers;

	use App\Event;
	use App\Http\Resources\Event as EventResource;
	use Illuminate\Http\Request;

	class HomeController extends Controller{
		/**
		 * Create a new controller instance.
		 *
		 * @return void
		 */
		public function __construct(){
			$this->middleware('auth');
		}

		/**
		 * Show the application dashboard.
		 *
		 * @return \Illuminate\Contracts\Support\Renderable
		 */
		public function index(Request $request){
			$events = EventResource::collection(Event::select()->paginate(100));
			return view('home', ['events' => $events->toArray($request)]);
		}
	}
