<?php

	namespace App;

	use Grimzy\LaravelMysqlSpatial\Eloquent\SpatialTrait;
	use Illuminate\Database\Eloquent\Model;
	use Illuminate\Database\Eloquent\SoftDeletes;

	class EventDate extends Model{
		use SoftDeletes;
		use SpatialTrait;

		public static $filterable = [
			'date',
			'title',
			'location',
			'locations.name',
			'events.kind',
			'events.name',
		];

		protected $fillable = [
			'event',
			'location',
			'gps',
			'canceled',
			'title',
			'description',
			'short_description',
			'street',
			'street_nr',
			'address_supplement',
			'date',
			'date_end',
			'start',
			'end',
			'whole_day',
		];

		protected $spatialFields = [
			'gps',
		];

		public function event(){
			return $this->belongsTo('App\Event', 'event');
		}

		public function location(){
			return $this->belongsTo('App\Location', 'location');
		}

	}
