<?php

	namespace App;

	use App\Http\Resources\Event as EventResource;
	use Grimzy\LaravelMysqlSpatial\Types\Point;
	use Illuminate\Database\Eloquent\Model;
	use Illuminate\Database\Eloquent\SoftDeletes;

	class Event extends Model{

		use SoftDeletes;
		use MediaRelationTrait;

		protected $fillable = [
			'name',
			'status',
			'kind',
			'organisation',
			'web',
			'mail',
			'phone',
			'registration',
			'price',
			'ticket_presale',
			'free',
			'facebook',
			'twitter',
			'instagram',
			'sustainability',
			'accessible',
			'family_friendly',
			'with_cost',
			'created_by',
		];

		public static $filterable = ['name', 'event_dates.title',];

		public function kind(){
			return $this->belongsTo('App\EventKind');
		}

		public function eventDate(){
			return $this->hasMany('App\EventDate', 'event', 'id');
		}

		public function updateEventDates($eventDates){
			$this->removeEventDate();
			foreach($eventDates as $eventDate){
				$eventDateModel = EventDate::find($eventDate['id']);
				if(empty($eventDate['gps']['lat']) || empty($eventDate['gps']['lng'])){
					unset($eventDate['gps']);
				}else{
					$eventDate['gps'] = new Point($eventDate['gps']['lat'], $eventDate['gps']['lng']);
				}

				$eventDate['event'] = $this->id;
				$eventDate['location'] = isset($eventDate['location']['id']) ? $eventDate['location']['id'] : $eventDate['location'];
				if($eventDateModel){
					$eventDateModel->update($eventDate);
				}else{
					EventDate::create($eventDate);
				}
			}
		}

		public function removeEventDate(){
			$eventDates = EventDate::where('event', '=', $this->id)
				->delete();
			return $this;
		}
	}
